/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.select;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.DefaultResourcePack;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.LegacyV2Adapter;
import net.minecraft.client.resources.ResourceIndex;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcUtil;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.reflection.client.renderer.texture.TextureManagerReflection;
import noppes.npcs.reflection.client.renderer.texture.TextureMapReflection;
import noppes.npcs.reflection.client.resources.AbstractResourcePackReflection;
import noppes.npcs.reflection.client.resources.DefaultResourcePackReflection;
import noppes.npcs.reflection.client.resources.FallbackResourceManagerReflection;
import noppes.npcs.reflection.client.resources.IResourceManagerReflection;
import noppes.npcs.reflection.client.resources.LegacyV2AdapterReflection;
import noppes.npcs.reflection.client.resources.ResourceIndexReflection;
import noppes.npcs.util.Util;

public class GuiTextureSelection
extends SubGuiInterface
implements ICustomScrollListener {
    protected GuiCustomScroll scroll;
    protected final Map<String, TreeMap<ResourceLocation, Long>> data = new TreeMap<String, TreeMap<ResourceLocation, Long>>();
    protected ResourceLocation selectDir;
    protected final String suffix;
    protected final int type;
    protected final String back = "   " + Character.toChars(8592)[0] + " (" + new TextComponentTranslation("gui.back", new Object[0]).func_150254_d() + ")";
    protected String baseResource = "";
    protected EntityNPCInterface displayNPC;
    protected int offsetX = 0;
    public ResourceLocation resource;
    public static boolean dark = false;

    public GuiTextureSelection(int idIn, EntityNPCInterface npcIn, String textureIn, String suffixIn, int typeIn) {
        this(npcIn, textureIn, suffixIn, typeIn);
        this.id = idIn;
    }

    public GuiTextureSelection(EntityNPCInterface npcIn, @Nonnull String textureIn, String suffixIn, int typeIn) {
        super(npcIn);
        ResourceLocation loc;
        if (this.npc != null) {
            this.displayNPC = Util.instance.copyToGUI(this.npc, (World)this.field_146297_k.field_71441_e, false);
        }
        this.drawDefaultBackground = false;
        this.title = "";
        this.setBackground("menubg.png");
        this.xSize = 366;
        this.ySize = 226;
        this.type = typeIn;
        this.selectDir = null;
        this.suffix = suffixIn.toLowerCase();
        if (ClientProxy.texturesData.containsKey(this.suffix)) {
            this.data.putAll(ClientProxy.texturesData.get(this.suffix));
        }
        if (this.data.containsKey((loc = new ResourceLocation(textureIn)).func_110624_b()) && !this.data.get(loc.func_110624_b()).containsKey(loc)) {
            try {
                if (!textureIn.isEmpty()) {
                    this.field_146297_k.func_110434_K().func_110577_a(loc);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.data.containsKey(loc.func_110624_b())) {
            this.resetFiles();
            ClientProxy.texturesData.put(this.suffix, this.data);
        }
        this.baseResource = textureIn;
        if (textureIn.isEmpty()) {
            if (this.selectDir == null) {
                switch (this.type) {
                    case 1: {
                        this.selectDir = new ResourceLocation("customnpcs", "textures/cloak");
                        break;
                    }
                    case 2: {
                        this.selectDir = new ResourceLocation("customnpcs", "textures/overlays");
                        break;
                    }
                    case 3: {
                        this.selectDir = new ResourceLocation("customnpcs", "textures/gui");
                        break;
                    }
                    default: {
                        this.selectDir = new ResourceLocation("customnpcs", "textures/entity/humanmale");
                    }
                }
            }
            return;
        }
        this.resource = new ResourceLocation(textureIn);
        if (textureIn.lastIndexOf("/") != -1) {
            textureIn = textureIn.substring(0, textureIn.lastIndexOf("/"));
        }
        this.selectDir = new ResourceLocation(textureIn);
        if (!this.data.containsKey(this.selectDir.func_110624_b())) {
            this.selectDir = null;
            return;
        }
        for (ResourceLocation r : this.data.get(this.selectDir.func_110624_b()).keySet()) {
            if (r.func_110623_a().indexOf(this.selectDir.func_110623_a()) != 0) continue;
            return;
        }
        this.selectDir = null;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (button.getID() == 3) {
            dark = ((GuiNpcCheckBox)button).isSelected();
            return;
        }
        String res = this.baseResource;
        if (button.getID() == 2 && this.resource != null) {
            res = this.resource.toString();
        }
        if (this.npc != null && this.type >= 0 && this.type <= 2) {
            switch (this.type) {
                case 1: {
                    this.npc.display.setCapeTexture(res);
                    this.displayNPC.display.setCapeTexture(res);
                    break;
                }
                case 2: {
                    this.npc.display.setOverlayTexture(res);
                    this.displayNPC.display.setOverlayTexture(res);
                    break;
                }
                default: {
                    this.npc.display.setSkinTexture(res);
                    this.displayNPC.display.setSkinTexture(res);
                }
            }
            this.npc.textureLocation = null;
            this.displayNPC.textureLocation = null;
        }
        this.close();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)2.0f, (float)2.0f, (float)2.0f, (float)1.0f);
        int x = this.guiLeft + 271;
        int y = this.guiTop + 6;
        int w = 80;
        if (this.type == 4) {
            GlStateManager.func_179109_b((float)19.5f, (float)0.0f, (float)0.0f);
            w = 41;
        }
        Gui.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + w + 1), (int)(y + 81), (int)(dark ? new Color(-2039584).getRGB() : new Color(-14671840).getRGB()));
        Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + 80), (int)(dark ? new Color(-16777216).getRGB() : new Color(-1).getRGB()));
        int g = 5;
        for (int u = 0; u < w / g; ++u) {
            for (int v = 0; v < 80 / g; ++v) {
                if (u % 2 != (v % 2 == 0 ? 1 : 0)) continue;
                Gui.func_73734_a((int)(x + u * g), (int)(y + v * g), (int)(x + u * g + g), (int)(y + v * g + g), (int)(dark ? new Color(-13355980).getRGB() : new Color(-3355444).getRGB()));
            }
        }
        GlStateManager.func_179121_F();
        if (this.resource != null) {
            float scale = 0.3125f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            try {
                int tX = 0;
                int tY = 0;
                int tW = 256;
                int tH = 256;
                int tS = 256;
                if (this.type == 4) {
                    GlStateManager.func_179109_b((float)62.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)3.3f, (float)2.0f, (float)1.0f);
                    tX = 4;
                    tY = 4;
                    tW = 40;
                    tH = 128;
                }
                GuiNpcUtil.drawTexturedModalRect(this.resource, tX, tY, tW, tH, (float)tS);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        if (this.npc != null && this.type >= 0 && this.type <= 2) {
            if (this.type == 0) {
                this.npc.textureLocation = this.resource;
                this.displayNPC.textureLocation = this.resource;
            }
            float s = 1.25f;
            int mouse = 0;
            x = 0;
            y = 0;
            int rot = this.type == 0 ? (int)(3L * this.player.field_70170_p.func_82737_E() % 360L) : (this.type == 1 ? 215 : 325);
            if (this.npc.textureLocation != null) {
                this.drawNpc((Entity)this.displayNPC, this.guiLeft + 276 + x, this.guiTop + 155 + y, s, rot, 0, mouse);
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft += this.offsetX;
        GuiNpcButton button = new GuiNpcButton(1, this.guiLeft + 264, this.guiTop + 190, 90, 20, "gui.cancel");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, this.guiLeft + 264, this.guiTop + 170, 90, 20, "gui.done");
        button.setHoverText("texture.hover.done", new Object[0]);
        this.addButton(button);
        button = new GuiNpcCheckBox(3, this.guiLeft + 254, this.guiTop + 5, 15, 15, null, null, dark);
        button.setHoverText("texture.hover.dark", new Object[0]);
        this.addButton(button);
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(250, 199);
        }
        this.scroll.guiLeft = this.guiLeft + 4;
        this.scroll.guiTop = this.guiTop + 14;
        String domain = "All Data in Game/";
        if (this.selectDir == null) {
            this.scroll.setList(new ArrayList<String>(this.data.keySet()));
        } else {
            String txrName;
            ArrayList<String> list = new ArrayList<String>();
            TreeMap<String, Long> ds = new TreeMap<String, Long>();
            TreeMap<String, Long> fs = new TreeMap<String, Long>();
            String path = this.selectDir.func_110623_a();
            for (ResourceLocation res : this.data.get(this.selectDir.func_110624_b()).keySet()) {
                if (res.func_110623_a().indexOf(path) != 0) continue;
                String key = res.func_110623_a().substring(path.length() + 1);
                if (key.contains("/")) {
                    ds.put(key.substring(0, key.indexOf("/")), this.data.get(this.selectDir.func_110624_b()).get(res));
                    continue;
                }
                if (!this.suffix.isEmpty() && !res.func_110623_a().toLowerCase().endsWith(this.suffix)) continue;
                fs.put(res.func_110623_a().substring(res.func_110623_a().lastIndexOf("/") + 1), this.data.get(this.selectDir.func_110624_b()).get(res));
            }
            String string = txrName = this.resource != null ? this.resource.func_110623_a() : "";
            if (!txrName.isEmpty()) {
                txrName = txrName.substring(txrName.lastIndexOf("/") + 1);
            }
            ArrayList<Integer> colors = new ArrayList<Integer>();
            ArrayList<String> suffixes = new ArrayList<String>();
            int i = 1;
            int pos = -1;
            suffixes.add("");
            colors.add(new Color(15973918).getRGB());
            for (String key : ds.keySet()) {
                suffixes.add("");
                list.add(key);
                colors.add(new Color(15973918).getRGB());
                ++i;
            }
            for (String key : fs.keySet()) {
                suffixes.add(Util.instance.getTextReducedNumber(((Long)fs.get(key)).longValue(), false, false, true) + "b");
                list.add(key);
                colors.add(new Color(0xCAEAEA).getRGB());
                if (txrName.equals(key)) {
                    pos = i;
                }
                ++i;
            }
            list.add(0, this.back);
            this.scroll.setColors(colors);
            this.scroll.setSuffixes(suffixes);
            this.scroll.setListNotSorted(list);
            if (this.scroll.getSelect() != pos) {
                this.scroll.setSelect(pos);
            }
            this.scroll.resetRoll();
            char chr = '\u00a7';
            domain = chr + "l" + this.selectDir.func_110624_b() + "/" + path;
            while (this.field_146297_k.field_71466_p.func_78256_a(domain) > 250 && path.contains("/")) {
                path = path.substring(path.indexOf("/") + 1);
                domain = chr + "l" + this.selectDir.func_110624_b() + "/.../" + path;
            }
        }
        this.addScroll(this.scroll);
        this.addLabel(new GuiNpcLabel(0, domain, this.guiLeft + 4, this.guiTop + 4));
        this.getLabel(0).setColor(new Color(new Color(-16777216).getRGB()).getRGB());
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (scroll.getSelected().equals(this.back)) {
            if (this.selectDir == null) {
                return;
            }
            this.selectDir = !this.selectDir.func_110623_a().contains("/") ? null : new ResourceLocation(this.selectDir.func_110624_b(), this.selectDir.func_110623_a().substring(0, this.selectDir.func_110623_a().lastIndexOf("/")));
            this.func_73866_w_();
        } else if (this.selectDir != null) {
            if (!scroll.getSelected().endsWith(this.suffix)) {
                this.selectDir = new ResourceLocation(this.selectDir.func_110624_b(), this.selectDir.func_110623_a() + "/" + scroll.getSelected());
                this.func_73866_w_();
            } else {
                this.resource = new ResourceLocation(this.selectDir.func_110624_b(), this.selectDir.func_110623_a() + "/" + scroll.getSelected());
                if (this.npc != null && this.type >= 0 && this.type <= 2) {
                    switch (this.type) {
                        case 1: {
                            this.npc.display.setCapeTexture(this.resource.toString());
                            break;
                        }
                        case 2: {
                            this.npc.display.setOverlayTexture(this.resource.toString());
                            break;
                        }
                        default: {
                            this.npc.display.setSkinTexture(this.resource.toString());
                            break;
                        }
                    }
                }
            }
        } else if (this.data.containsKey(scroll.getSelected())) {
            String res = null;
            String def = null;
            for (ResourceLocation loc : this.data.get(scroll.getSelected()).keySet()) {
                if (def == null) {
                    def = loc.func_110623_a().substring(0, loc.func_110623_a().indexOf("/"));
                }
                if (!loc.func_110623_a().substring(0, loc.func_110623_a().indexOf("/")).equals("textures")) continue;
                res = "textures";
                break;
            }
            if (res == null && def != null) {
                res = def;
            }
            if (res == null) {
                return;
            }
            this.selectDir = new ResourceLocation(scroll.getSelected(), res);
            this.func_73866_w_();
        }
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
        if (this.resource != null) {
            if (this.npc != null && this.type >= 0 && this.type <= 2) {
                switch (this.type) {
                    case 1: {
                        this.npc.display.setCapeTexture(this.resource.toString());
                        this.displayNPC.display.setCapeTexture(this.resource.toString());
                        break;
                    }
                    case 2: {
                        this.npc.display.setOverlayTexture(this.resource.toString());
                        this.displayNPC.display.setOverlayTexture(this.resource.toString());
                        break;
                    }
                    default: {
                        this.npc.display.setSkinTexture(this.resource.toString());
                        this.displayNPC.display.setSkinTexture(this.resource.toString());
                    }
                }
            }
            this.close();
            this.parent.func_73866_w_();
        }
    }

    private void progressFile(File file) {
        try {
            if (!file.isDirectory() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"))) {
                ZipFile zip = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipentry = entries.nextElement();
                    String entryName = zipentry.getName();
                    int a = entryName.indexOf("assets");
                    int t = entryName.indexOf("texture", a);
                    if (a == -1 || t == -1) continue;
                    this.addFile(entryName, zipentry.getSize());
                }
                zip.close();
            } else if (file.isDirectory()) {
                this.checkFolder(file);
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    private void resetFiles() {
        this.data.clear();
        this.field_146297_k = Minecraft.func_71410_x();
        for (ResourceLocation resourceLocation : TextureManagerReflection.getMapTextureObjects(this.field_146297_k.func_110434_K()).keySet()) {
            this.addFile(resourceLocation);
        }
        for (String string : TextureMapReflection.getMapRegisteredSprites(this.field_146297_k.func_147117_R()).keySet()) {
            try {
                this.addFile(new ResourceLocation(string.substring(0, string.indexOf(":")), "textures/" + string.substring(string.indexOf(":") + 1) + ".png"));
            }
            catch (Exception exception) {}
        }
        Map<String, FallbackResourceManager> map = IResourceManagerReflection.getDomainResourceManagers(this.field_146297_k.func_110442_L());
        if (map == null) {
            return;
        }
        for (String name : map.keySet()) {
            List<IResourcePack> list = FallbackResourceManagerReflection.getResourcePacks(map.get(name));
            if (list == null) {
                return;
            }
            for (IResourcePack pack : list) {
                File dir;
                File directory;
                if (pack instanceof LegacyV2Adapter) {
                    pack = LegacyV2AdapterReflection.getIResourcePack((LegacyV2Adapter)pack);
                }
                if (pack instanceof DefaultResourcePack) {
                    ResourceIndex resourceIndex = DefaultResourcePackReflection.getResourceIndex((DefaultResourcePack)pack);
                    Map<String, File> resourceMap = ResourceIndexReflection.getResourceMap(resourceIndex);
                    for (String key : resourceMap.keySet()) {
                        File f = resourceMap.get(key);
                        this.addFile(key, f.length());
                    }
                    continue;
                }
                if (!(pack instanceof AbstractResourcePack) || (directory = AbstractResourcePackReflection.getResourcePackFile((AbstractResourcePack)pack)) == null || !directory.isDirectory() || !(dir = new File(directory, "assets")).exists() || !dir.isDirectory()) continue;
                this.checkFolder(dir);
            }
        }
        for (ModContainer mod : Loader.instance().getModList()) {
            if (!mod.getSource().exists()) continue;
            this.progressFile(mod.getSource());
        }
        ResourcePackRepository resourcePackRepository = Minecraft.func_71410_x().func_110438_M();
        for (ResourcePackRepository.Entry entry : resourcePackRepository.func_110613_c()) {
            File file = new File(resourcePackRepository.func_110612_e(), entry.func_110515_d());
            if (!file.exists()) continue;
            this.progressFile(file);
        }
        this.checkFolder(new File(CustomNpcs.Dir, "assets"));
    }

    private void addFile(ResourceLocation location) {
        String path = location.func_110623_a();
        if (!this.suffix.isEmpty() && !path.toLowerCase().endsWith(this.suffix)) {
            return;
        }
        String domain = location.func_110624_b();
        if (!this.data.containsKey(domain)) {
            this.data.put(domain, new TreeMap());
        } else {
            for (ResourceLocation r : this.data.get(domain).keySet()) {
                if (!r.func_110623_a().equals(path)) continue;
                return;
            }
        }
        long size = 0L;
        try {
            IResource res = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
            try (InputStream inputStream = res.func_110527_b();){
                int readByte;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((readByte = inputStream.read()) != -1) {
                    byteArrayOutputStream.write(readByte);
                }
                byte[] bytes = byteArrayOutputStream.toByteArray();
                size = bytes.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.data.get(domain).put(location, size);
    }

    private void addFile(String path, long size) {
        String domain;
        if (!this.suffix.isEmpty() && !path.toLowerCase().endsWith(this.suffix)) {
            return;
        }
        if (path == null || !path.contains("assets")) {
            return;
        }
        if (path.contains("\\")) {
            ArrayList<String> list = new ArrayList<String>();
            while (path.contains("\\")) {
                list.add(path.substring(0, path.indexOf("\\")));
                path = path.substring(path.indexOf("\\") + 1);
            }
            list.add(path);
            StringBuilder pathBuilder = new StringBuilder();
            for (String p : list) {
                pathBuilder.append(p).append("/");
            }
            path = pathBuilder.toString();
            path = path.substring(0, path.length() - 1);
        }
        if ((domain = (path = path.substring(path.lastIndexOf("assets") + 7)).substring(0, path.indexOf("/"))).isEmpty()) {
            return;
        }
        if (!(path = path.substring(path.indexOf("/") + 1)).startsWith("textures")) {
            return;
        }
        ResourceLocation res = new ResourceLocation(domain, path);
        if (!this.data.containsKey(domain)) {
            this.data.put(domain, new TreeMap());
        } else {
            for (ResourceLocation r : this.data.get(domain).keySet()) {
                if (!r.func_110623_a().equals(path)) continue;
                return;
            }
        }
        this.data.get(domain).put(res, size);
    }

    private void checkFolder(File file) {
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                this.checkFolder(f);
                continue;
            }
            this.addFile(f.getAbsolutePath(), f.length());
        }
    }

    public GuiTextureSelection setOffsetX(int posX) {
        this.offsetX = posX;
        return this;
    }
}

